<?php
// This file was auto-generated from sdk-root/src/data/gamesparks/2021-08-17/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2021-08-17', 'endpointPrefix' => 'gamesparks', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'GameSparks', 'serviceId' => 'GameSparks', 'signatureVersion' => 'v4', 'signingName' => 'gamesparks', 'uid' => 'gamesparks-2021-08-17', ], 'operations' => [ 'CreateGame' => [ 'name' => 'CreateGame', 'http' => [ 'method' => 'POST', 'requestUri' => '/game', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateGameRequest', ], 'output' => [ 'shape' => 'CreateGameResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'CreateSnapshot' => [ 'name' => 'CreateSnapshot', 'http' => [ 'method' => 'POST', 'requestUri' => '/game/{GameName}/snapshot', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateSnapshotRequest', ], 'output' => [ 'shape' => 'CreateSnapshotResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateStage' => [ 'name' => 'CreateStage', 'http' => [ 'method' => 'POST', 'requestUri' => '/game/{GameName}/stage', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateStageRequest', ], 'output' => [ 'shape' => 'CreateStageResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteGame' => [ 'name' => 'DeleteGame', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/game/{GameName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteGameRequest', ], 'output' => [ 'shape' => 'DeleteGameResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteStage' => [ 'name' => 'DeleteStage', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/game/{GameName}/stage/{StageName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteStageRequest', ], 'output' => [ 'shape' => 'DeleteStageResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DisconnectPlayer' => [ 'name' => 'DisconnectPlayer', 'http' => [ 'method' => 'POST', 'requestUri' => '/runtime/game/{GameName}/stage/{StageName}/player/{PlayerId}/disconnect', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisconnectPlayerRequest', ], 'output' => [ 'shape' => 'DisconnectPlayerResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'ExportSnapshot' => [ 'name' => 'ExportSnapshot', 'http' => [ 'method' => 'GET', 'requestUri' => '/game/{GameName}/snapshot/{SnapshotId}/export', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ExportSnapshotRequest', ], 'output' => [ 'shape' => 'ExportSnapshotResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetExtension' => [ 'name' => 'GetExtension', 'http' => [ 'method' => 'GET', 'requestUri' => '/extension/{Namespace}/{Name}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetExtensionRequest', ], 'output' => [ 'shape' => 'GetExtensionResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetExtensionVersion' => [ 'name' => 'GetExtensionVersion', 'http' => [ 'method' => 'GET', 'requestUri' => '/extension/{Namespace}/{Name}/version/{ExtensionVersion}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetExtensionVersionRequest', ], 'output' => [ 'shape' => 'GetExtensionVersionResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetGame' => [ 'name' => 'GetGame', 'http' => [ 'method' => 'GET', 'requestUri' => '/game/{GameName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetGameRequest', ], 'output' => [ 'shape' => 'GetGameResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetGameConfiguration' => [ 'name' => 'GetGameConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/game/{GameName}/configuration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetGameConfigurationRequest', ], 'output' => [ 'shape' => 'GetGameConfigurationResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetGeneratedCodeJob' => [ 'name' => 'GetGeneratedCodeJob', 'http' => [ 'method' => 'GET', 'requestUri' => '/game/{GameName}/snapshot/{SnapshotId}/generated-sdk-code-job/{JobId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetGeneratedCodeJobRequest', ], 'output' => [ 'shape' => 'GetGeneratedCodeJobResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetPlayerConnectionStatus' => [ 'name' => 'GetPlayerConnectionStatus', 'http' => [ 'method' => 'GET', 'requestUri' => '/runtime/game/{GameName}/stage/{StageName}/player/{PlayerId}/connection', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetPlayerConnectionStatusRequest', ], 'output' => [ 'shape' => 'GetPlayerConnectionStatusResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetSnapshot' => [ 'name' => 'GetSnapshot', 'http' => [ 'method' => 'GET', 'requestUri' => '/game/{GameName}/snapshot/{SnapshotId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSnapshotRequest', ], 'output' => [ 'shape' => 'GetSnapshotResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetStage' => [ 'name' => 'GetStage', 'http' => [ 'method' => 'GET', 'requestUri' => '/game/{GameName}/stage/{StageName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetStageRequest', ], 'output' => [ 'shape' => 'GetStageResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetStageDeployment' => [ 'name' => 'GetStageDeployment', 'http' => [ 'method' => 'GET', 'requestUri' => '/game/{GameName}/stage/{StageName}/deployment', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetStageDeploymentRequest', ], 'output' => [ 'shape' => 'GetStageDeploymentResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ImportGameConfiguration' => [ 'name' => 'ImportGameConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/game/{GameName}/configuration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ImportGameConfigurationRequest', ], 'output' => [ 'shape' => 'ImportGameConfigurationResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'ListExtensionVersions' => [ 'name' => 'ListExtensionVersions', 'http' => [ 'method' => 'GET', 'requestUri' => '/extension/{Namespace}/{Name}/version', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListExtensionVersionsRequest', ], 'output' => [ 'shape' => 'ListExtensionVersionsResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListExtensions' => [ 'name' => 'ListExtensions', 'http' => [ 'method' => 'GET', 'requestUri' => '/extension', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListExtensionsRequest', ], 'output' => [ 'shape' => 'ListExtensionsResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListGames' => [ 'name' => 'ListGames', 'http' => [ 'method' => 'GET', 'requestUri' => '/game', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListGamesRequest', ], 'output' => [ 'shape' => 'ListGamesResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListGeneratedCodeJobs' => [ 'name' => 'ListGeneratedCodeJobs', 'http' => [ 'method' => 'GET', 'requestUri' => '/game/{GameName}/snapshot/{SnapshotId}/generated-sdk-code-jobs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListGeneratedCodeJobsRequest', ], 'output' => [ 'shape' => 'ListGeneratedCodeJobsResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListSnapshots' => [ 'name' => 'ListSnapshots', 'http' => [ 'method' => 'GET', 'requestUri' => '/game/{GameName}/snapshot', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSnapshotsRequest', ], 'output' => [ 'shape' => 'ListSnapshotsResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListStageDeployments' => [ 'name' => 'ListStageDeployments', 'http' => [ 'method' => 'GET', 'requestUri' => '/game/{GameName}/stage/{StageName}/deployments', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListStageDeploymentsRequest', ], 'output' => [ 'shape' => 'ListStageDeploymentsResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListStages' => [ 'name' => 'ListStages', 'http' => [ 'method' => 'GET', 'requestUri' => '/game/{GameName}/stage', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListStagesRequest', ], 'output' => [ 'shape' => 'ListStagesResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{ResourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'StartGeneratedCodeJob' => [ 'name' => 'StartGeneratedCodeJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/game/{GameName}/snapshot/{SnapshotId}/generated-sdk-code-job', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartGeneratedCodeJobRequest', ], 'output' => [ 'shape' => 'StartGeneratedCodeJobResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'StartStageDeployment' => [ 'name' => 'StartStageDeployment', 'http' => [ 'method' => 'POST', 'requestUri' => '/game/{GameName}/stage/{StageName}/deployment', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartStageDeploymentRequest', ], 'output' => [ 'shape' => 'StartStageDeploymentResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{ResourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{ResourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateGame' => [ 'name' => 'UpdateGame', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/game/{GameName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateGameRequest', ], 'output' => [ 'shape' => 'UpdateGameResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateGameConfiguration' => [ 'name' => 'UpdateGameConfiguration', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/game/{GameName}/configuration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateGameConfigurationRequest', ], 'output' => [ 'shape' => 'UpdateGameConfigurationResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], 'idempotent' => true, ], 'UpdateSnapshot' => [ 'name' => 'UpdateSnapshot', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/game/{GameName}/snapshot/{SnapshotId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSnapshotRequest', ], 'output' => [ 'shape' => 'UpdateSnapshotResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateStage' => [ 'name' => 'UpdateStage', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/game/{GameName}/stage/{StageName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateStageRequest', ], 'output' => [ 'shape' => 'UpdateStageResult', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'ARN' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => '^[A-Za-z0-9:_/-]+$', ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'ByteSize' => [ 'type' => 'integer', 'min' => 0, ], 'ClientToken' => [ 'type' => 'string', 'max' => 126, 'min' => 33, ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'Connection' => [ 'type' => 'structure', 'members' => [ 'Created' => [ 'shape' => 'DateTime', ], 'Id' => [ 'shape' => 'ConnectionId', ], ], ], 'ConnectionId' => [ 'type' => 'string', 'max' => 36, 'min' => 1, ], 'ConnectionIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConnectionId', ], ], 'ConnectionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Connection', ], ], 'CreateGameRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', ], 'members' => [ 'ClientToken' => [ 'shape' => 'ClientToken', ], 'Description' => [ 'shape' => 'GameDescription', ], 'GameName' => [ 'shape' => 'GameName', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateGameResult' => [ 'type' => 'structure', 'members' => [ 'Game' => [ 'shape' => 'GameDetails', ], ], ], 'CreateSnapshotRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', ], 'members' => [ 'Description' => [ 'shape' => 'SnapshotDescription', ], 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], ], ], 'CreateSnapshotResult' => [ 'type' => 'structure', 'members' => [ 'Snapshot' => [ 'shape' => 'SnapshotDetails', ], ], ], 'CreateStageRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'Role', 'StageName', ], 'members' => [ 'ClientToken' => [ 'shape' => 'ClientToken', ], 'Description' => [ 'shape' => 'StageDescription', ], 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'Role' => [ 'shape' => 'RoleARN', ], 'StageName' => [ 'shape' => 'StageName', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateStageResult' => [ 'type' => 'structure', 'members' => [ 'Stage' => [ 'shape' => 'StageDetails', ], ], ], 'DateTime' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'DeleteGameRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], ], ], 'DeleteGameResult' => [ 'type' => 'structure', 'members' => [], ], 'DeleteStageRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'StageName', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'StageName' => [ 'shape' => 'StageName', 'location' => 'uri', 'locationName' => 'StageName', ], ], ], 'DeleteStageResult' => [ 'type' => 'structure', 'members' => [], ], 'DeploymentAction' => [ 'type' => 'string', 'enum' => [ 'DEPLOY', 'UNDEPLOY', ], ], 'DeploymentId' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^\\S(.*\\S)?$', ], 'DeploymentResult' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'Message', ], 'ResultCode' => [ 'shape' => 'ResultCode', ], ], ], 'DeploymentState' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'IN_PROGRESS', 'COMPLETED', 'FAILED', ], ], 'DisconnectPlayerRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'PlayerId', 'StageName', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'PlayerId' => [ 'shape' => 'PlayerId', 'location' => 'uri', 'locationName' => 'PlayerId', ], 'StageName' => [ 'shape' => 'StageName', 'location' => 'uri', 'locationName' => 'StageName', ], ], ], 'DisconnectPlayerResult' => [ 'type' => 'structure', 'members' => [ 'DisconnectFailures' => [ 'shape' => 'ConnectionIdList', ], 'DisconnectSuccesses' => [ 'shape' => 'ConnectionIdList', ], ], ], 'Document' => [ 'type' => 'structure', 'members' => [], 'document' => true, ], 'ExceptionMessage' => [ 'type' => 'string', ], 'ExportSnapshotRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'SnapshotId', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'SnapshotId' => [ 'shape' => 'SnapshotId', 'location' => 'uri', 'locationName' => 'SnapshotId', ], ], ], 'ExportSnapshotResult' => [ 'type' => 'structure', 'members' => [ 'S3Url' => [ 'shape' => 'S3PresignedUrl', ], ], ], 'ExtensionDescription' => [ 'type' => 'string', 'max' => 250, 'min' => 0, 'pattern' => '^\\S(.*\\S)?$|^$', ], 'ExtensionDetails' => [ 'type' => 'structure', 'members' => [ 'Description' => [ 'shape' => 'ExtensionDescription', ], 'Name' => [ 'shape' => 'ExtensionName', ], 'Namespace' => [ 'shape' => 'ExtensionNamespace', ], ], ], 'ExtensionDetailsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ExtensionDetails', ], ], 'ExtensionName' => [ 'type' => 'string', 'max' => 36, 'min' => 1, 'pattern' => '^[a-zA-Z0-9_-]+$', ], 'ExtensionNamespace' => [ 'type' => 'string', 'max' => 36, 'min' => 1, 'pattern' => '^[a-zA-Z0-9_-]+$', ], 'ExtensionVersion' => [ 'type' => 'string', 'max' => 20, 'min' => 0, ], 'ExtensionVersionDetails' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'ExtensionName', ], 'Namespace' => [ 'shape' => 'ExtensionNamespace', ], 'Schema' => [ 'shape' => 'ExtensionVersionSchema', ], 'Version' => [ 'shape' => 'ExtensionVersion', ], ], ], 'ExtensionVersionDetailsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ExtensionVersionDetails', ], ], 'ExtensionVersionSchema' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, ], 'GameConfigurationDetails' => [ 'type' => 'structure', 'members' => [ 'Created' => [ 'shape' => 'DateTime', ], 'LastUpdated' => [ 'shape' => 'DateTime', ], 'Sections' => [ 'shape' => 'Sections', ], ], ], 'GameDescription' => [ 'type' => 'string', 'max' => 250, 'min' => 0, 'pattern' => '^\\S(.*\\S)?$|^$', ], 'GameDetails' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'ARN', ], 'Created' => [ 'shape' => 'DateTime', ], 'Description' => [ 'shape' => 'GameDescription', ], 'EnableTerminationProtection' => [ 'shape' => 'GameTerminationProtection', ], 'LastUpdated' => [ 'shape' => 'DateTime', ], 'Name' => [ 'shape' => 'GameName', ], 'State' => [ 'shape' => 'GameState', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'GameKey' => [ 'type' => 'string', 'max' => 44, 'min' => 1, ], 'GameName' => [ 'type' => 'string', 'max' => 36, 'min' => 1, 'pattern' => '^[a-zA-Z0-9_-]+$', ], 'GameSdkVersion' => [ 'type' => 'string', 'max' => 10, 'min' => 5, 'pattern' => '^(\\d|[1-9]\\d*)\\.(\\d|[0-9]\\d*)\\.(\\d|[0-9]\\d*)$', ], 'GameState' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DELETING', ], ], 'GameSummary' => [ 'type' => 'structure', 'members' => [ 'Description' => [ 'shape' => 'GameDescription', ], 'Name' => [ 'shape' => 'GameName', ], 'State' => [ 'shape' => 'GameState', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'GameSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GameSummary', ], ], 'GameTerminationProtection' => [ 'type' => 'boolean', ], 'GeneratedCodeJobDescription' => [ 'type' => 'string', 'max' => 250, 'min' => 0, 'pattern' => '^\\S(.*\\S)?$|^$', ], 'GeneratedCodeJobDetails' => [ 'type' => 'structure', 'members' => [ 'Description' => [ 'shape' => 'GeneratedCodeJobDescription', ], 'ExpirationTime' => [ 'shape' => 'DateTime', ], 'GeneratedCodeJobId' => [ 'shape' => 'GeneratedCodeJobId', ], 'S3Url' => [ 'shape' => 'S3PresignedUrl', ], 'Status' => [ 'shape' => 'GeneratedCodeJobState', ], ], ], 'GeneratedCodeJobDetailsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GeneratedCodeJobDetails', ], ], 'GeneratedCodeJobId' => [ 'type' => 'string', 'pattern' => '^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$', ], 'GeneratedCodeJobState' => [ 'type' => 'string', 'enum' => [ 'IN_PROGRESS', 'COMPLETED', 'FAILED', 'PENDING', ], ], 'Generator' => [ 'type' => 'structure', 'members' => [ 'GameSdkVersion' => [ 'shape' => 'GameSdkVersion', ], 'Language' => [ 'shape' => 'Language', ], 'TargetPlatform' => [ 'shape' => 'TargetPlatform', ], ], ], 'GetExtensionRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'Namespace', ], 'members' => [ 'Name' => [ 'shape' => 'ExtensionName', 'location' => 'uri', 'locationName' => 'Name', ], 'Namespace' => [ 'shape' => 'ExtensionNamespace', 'location' => 'uri', 'locationName' => 'Namespace', ], ], ], 'GetExtensionResult' => [ 'type' => 'structure', 'members' => [ 'Extension' => [ 'shape' => 'ExtensionDetails', ], ], ], 'GetExtensionVersionRequest' => [ 'type' => 'structure', 'required' => [ 'ExtensionVersion', 'Name', 'Namespace', ], 'members' => [ 'ExtensionVersion' => [ 'shape' => 'ExtensionVersion', 'location' => 'uri', 'locationName' => 'ExtensionVersion', ], 'Name' => [ 'shape' => 'ExtensionName', 'location' => 'uri', 'locationName' => 'Name', ], 'Namespace' => [ 'shape' => 'ExtensionNamespace', 'location' => 'uri', 'locationName' => 'Namespace', ], ], ], 'GetExtensionVersionResult' => [ 'type' => 'structure', 'members' => [ 'ExtensionVersion' => [ 'shape' => 'ExtensionVersionDetails', ], ], ], 'GetGameConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'Sections' => [ 'shape' => 'SectionList', 'location' => 'querystring', 'locationName' => 'Sections', ], ], ], 'GetGameConfigurationResult' => [ 'type' => 'structure', 'members' => [ 'GameConfiguration' => [ 'shape' => 'GameConfigurationDetails', ], ], ], 'GetGameRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], ], ], 'GetGameResult' => [ 'type' => 'structure', 'members' => [ 'Game' => [ 'shape' => 'GameDetails', ], ], ], 'GetGeneratedCodeJobRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'JobId', 'SnapshotId', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'JobId' => [ 'shape' => 'GeneratedCodeJobId', 'location' => 'uri', 'locationName' => 'JobId', ], 'SnapshotId' => [ 'shape' => 'SnapshotId', 'location' => 'uri', 'locationName' => 'SnapshotId', ], ], ], 'GetGeneratedCodeJobResult' => [ 'type' => 'structure', 'members' => [ 'GeneratedCodeJob' => [ 'shape' => 'GeneratedCodeJobDetails', ], ], ], 'GetPlayerConnectionStatusRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'PlayerId', 'StageName', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'PlayerId' => [ 'shape' => 'PlayerId', 'location' => 'uri', 'locationName' => 'PlayerId', ], 'StageName' => [ 'shape' => 'StageName', 'location' => 'uri', 'locationName' => 'StageName', ], ], ], 'GetPlayerConnectionStatusResult' => [ 'type' => 'structure', 'members' => [ 'Connections' => [ 'shape' => 'ConnectionList', ], ], ], 'GetSnapshotRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'SnapshotId', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'Sections' => [ 'shape' => 'SectionList', 'location' => 'querystring', 'locationName' => 'Sections', ], 'SnapshotId' => [ 'shape' => 'SnapshotId', 'location' => 'uri', 'locationName' => 'SnapshotId', ], ], ], 'GetSnapshotResult' => [ 'type' => 'structure', 'members' => [ 'Snapshot' => [ 'shape' => 'SnapshotDetails', ], ], ], 'GetStageDeploymentRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'StageName', ], 'members' => [ 'DeploymentId' => [ 'shape' => 'DeploymentId', 'location' => 'querystring', 'locationName' => 'DeploymentId', ], 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'StageName' => [ 'shape' => 'StageName', 'location' => 'uri', 'locationName' => 'StageName', ], ], ], 'GetStageDeploymentResult' => [ 'type' => 'structure', 'members' => [ 'StageDeployment' => [ 'shape' => 'StageDeploymentDetails', ], ], ], 'GetStageRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'StageName', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'StageName' => [ 'shape' => 'StageName', 'location' => 'uri', 'locationName' => 'StageName', ], ], ], 'GetStageResult' => [ 'type' => 'structure', 'members' => [ 'Stage' => [ 'shape' => 'StageDetails', ], ], ], 'ImportGameConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'ImportSource', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'ImportSource' => [ 'shape' => 'ImportGameConfigurationSource', ], ], ], 'ImportGameConfigurationResult' => [ 'type' => 'structure', 'members' => [ 'GameConfiguration' => [ 'shape' => 'GameConfigurationDetails', ], ], ], 'ImportGameConfigurationSource' => [ 'type' => 'structure', 'required' => [ 'File', ], 'members' => [ 'File' => [ 'shape' => 'RawGameConfigurationData', ], ], ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'Language' => [ 'type' => 'string', 'max' => 16, 'min' => 1, 'pattern' => '^[a-zA-Z_]+$', ], 'ListExtensionVersionsRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'Namespace', ], 'members' => [ 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], 'Name' => [ 'shape' => 'ExtensionName', 'location' => 'uri', 'locationName' => 'Name', ], 'Namespace' => [ 'shape' => 'ExtensionNamespace', 'location' => 'uri', 'locationName' => 'Namespace', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], ], ], 'ListExtensionVersionsResult' => [ 'type' => 'structure', 'members' => [ 'ExtensionVersions' => [ 'shape' => 'ExtensionVersionDetailsList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListExtensionsRequest' => [ 'type' => 'structure', 'members' => [ 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], ], ], 'ListExtensionsResult' => [ 'type' => 'structure', 'members' => [ 'Extensions' => [ 'shape' => 'ExtensionDetailsList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListGamesRequest' => [ 'type' => 'structure', 'members' => [ 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], ], ], 'ListGamesResult' => [ 'type' => 'structure', 'members' => [ 'Games' => [ 'shape' => 'GameSummaryList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListGeneratedCodeJobsRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'SnapshotId', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'SnapshotId' => [ 'shape' => 'SnapshotId', 'location' => 'uri', 'locationName' => 'SnapshotId', ], ], ], 'ListGeneratedCodeJobsResult' => [ 'type' => 'structure', 'members' => [ 'GeneratedCodeJobs' => [ 'shape' => 'GeneratedCodeJobDetailsList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListSnapshotsRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], ], ], 'ListSnapshotsResult' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'Snapshots' => [ 'shape' => 'SnapshotSummaryList', ], ], ], 'ListStageDeploymentsRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'StageName', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'StageName' => [ 'shape' => 'StageName', 'location' => 'uri', 'locationName' => 'StageName', ], ], ], 'ListStageDeploymentsResult' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'StageDeployments' => [ 'shape' => 'StageDeploymentList', ], ], ], 'ListStagesRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], ], ], 'ListStagesResult' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'Stages' => [ 'shape' => 'StageSummaryList', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceArn', ], 'members' => [ 'ResourceArn' => [ 'shape' => 'ResourceArn', 'location' => 'uri', 'locationName' => 'ResourceArn', ], ], ], 'ListTagsForResourceResult' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagMap', ], ], ], 'LogGroupName' => [ 'type' => 'string', 'max' => 512, 'min' => 1, ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'Message' => [ 'type' => 'string', ], 'NextToken' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '^\\S(.*\\S)?$', ], 'Operation' => [ 'type' => 'string', 'enum' => [ 'ADD', 'REMOVE', 'REPLACE', ], ], 'Path' => [ 'type' => 'string', 'max' => 500, 'min' => 1, 'pattern' => '^\\/.*[^\\/]$', ], 'PlayerId' => [ 'type' => 'string', 'max' => 44, 'min' => 1, 'pattern' => '^[a-zA-Z0-9_-]+$', ], 'RawGameConfigurationData' => [ 'type' => 'blob', 'max' => 1024000, 'min' => 10, ], 'ResourceArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => '^arn:aws:gamesparks:', ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ResultCode' => [ 'type' => 'string', 'enum' => [ 'SUCCESS', 'INVALID_ROLE_FAILURE', 'UNSPECIFIED_FAILURE', ], ], 'RoleARN' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => '^arn:(aws[a-zA-Z-]*)?:iam::\\d{12}:role/.+$', ], 'S3PresignedUrl' => [ 'type' => 'string', 'max' => 2048, 'min' => 10, 'pattern' => '^https:\\/\\/(.*)\\.s3(.*)\\.amazonaws\\.com\\/(.*)$', ], 'Section' => [ 'type' => 'structure', 'members' => [ 'Attributes' => [ 'shape' => 'Document', ], 'Name' => [ 'shape' => 'SectionName', ], 'Size' => [ 'shape' => 'ByteSize', ], ], ], 'SectionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SectionName', ], 'max' => 100, 'min' => 1, ], 'SectionModification' => [ 'type' => 'structure', 'required' => [ 'Operation', 'Path', 'Section', ], 'members' => [ 'Operation' => [ 'shape' => 'Operation', ], 'Path' => [ 'shape' => 'Path', ], 'Section' => [ 'shape' => 'SectionName', ], 'Value' => [ 'shape' => 'Document', ], ], ], 'SectionModificationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SectionModification', ], 'max' => 100, 'min' => 1, ], 'SectionName' => [ 'type' => 'string', 'max' => 36, 'min' => 1, 'pattern' => '^[a-zA-Z0-9.]+$', ], 'Sections' => [ 'type' => 'map', 'key' => [ 'shape' => 'SectionName', ], 'value' => [ 'shape' => 'Section', ], ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'SnapshotDescription' => [ 'type' => 'string', 'max' => 250, 'min' => 0, 'pattern' => '^\\S(.*\\S)?$|^$', ], 'SnapshotDetails' => [ 'type' => 'structure', 'members' => [ 'Created' => [ 'shape' => 'DateTime', ], 'Description' => [ 'shape' => 'SnapshotDescription', ], 'Id' => [ 'shape' => 'SnapshotId', ], 'LastUpdated' => [ 'shape' => 'DateTime', ], 'Sections' => [ 'shape' => 'Sections', ], ], ], 'SnapshotId' => [ 'type' => 'string', 'max' => 36, 'min' => 33, 'pattern' => '^Snapshot_\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3,6}Z$', ], 'SnapshotSummary' => [ 'type' => 'structure', 'members' => [ 'Created' => [ 'shape' => 'DateTime', ], 'Description' => [ 'shape' => 'SnapshotDescription', ], 'Id' => [ 'shape' => 'SnapshotId', ], 'LastUpdated' => [ 'shape' => 'DateTime', ], ], ], 'SnapshotSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SnapshotSummary', ], ], 'StageDeploymentDetails' => [ 'type' => 'structure', 'members' => [ 'Created' => [ 'shape' => 'DateTime', ], 'DeploymentAction' => [ 'shape' => 'DeploymentAction', ], 'DeploymentId' => [ 'shape' => 'DeploymentId', ], 'DeploymentResult' => [ 'shape' => 'DeploymentResult', ], 'DeploymentState' => [ 'shape' => 'DeploymentState', ], 'LastUpdated' => [ 'shape' => 'DateTime', ], 'SnapshotId' => [ 'shape' => 'SnapshotId', ], ], ], 'StageDeploymentList' => [ 'type' => 'list', 'member' => [ 'shape' => 'StageDeploymentSummary', ], ], 'StageDeploymentSummary' => [ 'type' => 'structure', 'members' => [ 'DeploymentAction' => [ 'shape' => 'DeploymentAction', ], 'DeploymentId' => [ 'shape' => 'DeploymentId', ], 'DeploymentResult' => [ 'shape' => 'DeploymentResult', ], 'DeploymentState' => [ 'shape' => 'DeploymentState', ], 'LastUpdated' => [ 'shape' => 'DateTime', ], 'SnapshotId' => [ 'shape' => 'SnapshotId', ], ], ], 'StageDescription' => [ 'type' => 'string', 'max' => 250, 'min' => 0, 'pattern' => '^\\S(.*\\S)?$|^$', ], 'StageDetails' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'ARN', ], 'Created' => [ 'shape' => 'DateTime', ], 'Description' => [ 'shape' => 'StageDescription', ], 'GameKey' => [ 'shape' => 'GameKey', ], 'LastUpdated' => [ 'shape' => 'DateTime', ], 'LogGroup' => [ 'shape' => 'LogGroupName', ], 'Name' => [ 'shape' => 'StageName', ], 'Role' => [ 'shape' => 'RoleARN', ], 'State' => [ 'shape' => 'StageState', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'StageName' => [ 'type' => 'string', 'max' => 36, 'min' => 1, 'pattern' => '^[a-zA-Z0-9_-]+$', ], 'StageState' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DELETING', ], ], 'StageSummary' => [ 'type' => 'structure', 'members' => [ 'Description' => [ 'shape' => 'StageDescription', ], 'GameKey' => [ 'shape' => 'GameKey', ], 'Name' => [ 'shape' => 'StageName', ], 'State' => [ 'shape' => 'StageState', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'StageSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'StageSummary', ], ], 'StartGeneratedCodeJobRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'Generator', 'SnapshotId', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'Generator' => [ 'shape' => 'Generator', ], 'SnapshotId' => [ 'shape' => 'SnapshotId', 'location' => 'uri', 'locationName' => 'SnapshotId', ], ], ], 'StartGeneratedCodeJobResult' => [ 'type' => 'structure', 'members' => [ 'GeneratedCodeJobId' => [ 'shape' => 'GeneratedCodeJobId', ], ], ], 'StartStageDeploymentRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'SnapshotId', 'StageName', ], 'members' => [ 'ClientToken' => [ 'shape' => 'ClientToken', ], 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'SnapshotId' => [ 'shape' => 'SnapshotId', ], 'StageName' => [ 'shape' => 'StageName', 'location' => 'uri', 'locationName' => 'StageName', ], ], ], 'StartStageDeploymentResult' => [ 'type' => 'structure', 'members' => [ 'StageDeployment' => [ 'shape' => 'StageDeploymentDetails', ], ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^(?!aws:)[a-zA-Z+-=._:/]+$', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 50, 'min' => 1, ], 'TagMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 50, 'min' => 1, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceArn', 'tags', ], 'members' => [ 'ResourceArn' => [ 'shape' => 'ResourceArn', 'location' => 'uri', 'locationName' => 'ResourceArn', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'TagResourceResult' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '^[\\s\\w+-=\\.:/@]*$', ], 'TargetPlatform' => [ 'type' => 'string', 'max' => 16, 'min' => 1, 'pattern' => '^[a-zA-Z]+$', ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceArn', 'tagKeys', ], 'members' => [ 'ResourceArn' => [ 'shape' => 'ResourceArn', 'location' => 'uri', 'locationName' => 'ResourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResult' => [ 'type' => 'structure', 'members' => [], ], 'UpdateGameConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'Modifications', ], 'members' => [ 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'Modifications' => [ 'shape' => 'SectionModificationList', ], ], ], 'UpdateGameConfigurationResult' => [ 'type' => 'structure', 'members' => [ 'GameConfiguration' => [ 'shape' => 'GameConfigurationDetails', ], ], ], 'UpdateGameRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', ], 'members' => [ 'Description' => [ 'shape' => 'GameDescription', ], 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], ], ], 'UpdateGameResult' => [ 'type' => 'structure', 'members' => [ 'Game' => [ 'shape' => 'GameDetails', ], ], ], 'UpdateSnapshotRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'SnapshotId', ], 'members' => [ 'Description' => [ 'shape' => 'SnapshotDescription', ], 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'SnapshotId' => [ 'shape' => 'SnapshotId', 'location' => 'uri', 'locationName' => 'SnapshotId', ], ], ], 'UpdateSnapshotResult' => [ 'type' => 'structure', 'members' => [ 'Snapshot' => [ 'shape' => 'SnapshotDetails', ], ], ], 'UpdateStageRequest' => [ 'type' => 'structure', 'required' => [ 'GameName', 'StageName', ], 'members' => [ 'Description' => [ 'shape' => 'StageDescription', ], 'GameName' => [ 'shape' => 'GameName', 'location' => 'uri', 'locationName' => 'GameName', ], 'Role' => [ 'shape' => 'RoleARN', ], 'StageName' => [ 'shape' => 'StageName', 'location' => 'uri', 'locationName' => 'StageName', ], ], ], 'UpdateStageResult' => [ 'type' => 'structure', 'members' => [ 'Stage' => [ 'shape' => 'StageDetails', ], ], ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ExceptionMessage', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], ],];
